#include "useful.h"
#include <cstdlib> // ldiv
#include <cmath> // modf

namespace useful {


	//std::string integer_to_string(int n)
	//{
	//	std::string s;
	//	bool is_negative = false;
	//	if (n < 0) {
	//		is_negative = true;
	//		n = -n;
	//	}
	//	std::div_t qr;
	//	qr.quot = n;
	//	do {
	//		qr = div(qr.quot,10);
	//		switch (qr.rem) {
	//		case 0: s += '0'; break;
	//		case 1: s += '1'; break;
	//		case 2: s += '2'; break;
	//		case 3: s += '3'; break;
	//		case 4: s += '4'; break;
	//		case 5: s += '5'; break;
	//		case 6: s += '6'; break;
	//		case 7: s += '7'; break;
	//		case 8: s += '8'; break;
	//		default: s += '9'; break;
	//		}
	//	} while (qr.quot != 0);

	//	if (is_negative) s += '-';
	//	std::reverse(s.begin(),s.end());
	//	return s;
	//}

	//std::string double_to_string(double d)
	//{
	//	double intpart,fracpart;
	//	fracpart = modf(d,&intpart);

	//	// compute integer part using integer_to_string
	//	std::string s = integer_to_string(int(intpart));

	//	// compute decimal part by multiplying up
	//	while (fracpart != 0.0) {
	//		fracpart *= 10;
	//		// chop off decimals and look at top digit
	//		switch (int(fracpart)) {
	//		case 0: s += '0'; break;
	//		case 1: s += '1'; break;
	//		case 2: s += '2'; break;
	//		case 3: s += '3'; break;
	//		case 4: s += '4'; break;
	//		case 5: s += '5'; break;
	//		case 6: s += '6'; break;
	//		case 7: s += '7'; break;
	//		case 8: s += '8'; break;
	//		default: s += '9'; break;
	//		}
	//		fracpart = modf(fracpart,&intpart);
	//	}

	//	return s;
	//}



	//// Template specialization for bool (convert to "true"/"false")
	//template <>
	//std::string stringify<bool>(const bool& x)
	//{
	//	return x ? "true" : "false";
	//}

	//// Template specialization for int
	//template <>
	//std::string stringify<int>(const int& x)
	//{
	//	return integer_to_string(x);
	//}

	//// Template specialization for double
	//template <>
	//std::string stringify<double>(const double& x)
	//{
	//	return double_to_string(x);
	//}

	//// Template specialization for long double
	//template <>
	//std::string stringify<long double>(const long double& x)
	//{
	//	return double_to_string(double(x));
	//}




	//// Template Specialization for bool
	//template <>
	//bool destringify<bool>(const std::string& s) 
	//{
	//	if (s == "false") return false;
	//	else if (s == "true") return true;
	//	else throw non_numeric();
	//}

	//template <>
	//short destringify<short>(const std::string& s) 
	//{
	//	return string_to_integer<short>(s);
	//}

	//template <>
	//int destringify<int>(const std::string& s)
	//{
	//	return string_to_integer<int>(s);
	//}

	//template <>
	//long destringify<long>(const std::string& s) 
	//{
	//	return string_to_integer<long>(s);
	//}

	//template <>
	//long long destringify<long long>(const std::string& s) 
	//{
	//	return string_to_integer<long long>(s);
	//}

	//template <>
	//unsigned short destringify<unsigned short>(const std::string& s)
	//{
	//	return string_to_unsigned<unsigned short>(s); 
	//}

	//template <>
	//unsigned destringify<unsigned>(const std::string& s) 
	//{ 
	//	return string_to_unsigned<unsigned>(s); 
	//}

	//template <>
	//unsigned long destringify<unsigned long>(const std::string& s)
	//{ 
	//	return string_to_unsigned<unsigned long>(s); 
	//}

	//template <>
	//unsigned long long destringify<unsigned long long>(const std::string& s) 
	//{ 
	//	return string_to_unsigned<unsigned long long>(s);
	//}

	//template <>
	//double destringify<double>(const std::string& s) { return string_to_float<double>(s); }

	//template <>
	//long double destringify<long double>(const std::string& s) { return string_to_float<long double>(s); }


	bool is_int(const std::string& s) 
	{
		std::string::const_iterator i = s.begin();
		if (i == s.end()) return false;
		// first character can be +,-, or digit
		if (*i != '-' && !std::isdigit(*i) && *i != '+') return false;
		// all other characters must be digits
		for ( ; i != s.end(); ++i) if (!std::isdigit(*i)) return false;
		return true;
	}

	bool is_uint(const std::string& s) 
	{
		for (auto i = s.begin(); i != s.end(); ++i)
			if (!std::isdigit(*i)) return false;
		return true;
	}

	unsigned pow(unsigned b, unsigned e) 
	{
		if (e == 0) return 1;
		if (e == 1) return b; // not necessary but provides faster code
		unsigned tmp = useful::pow(b,e/2);
		if (e % 2 == 0) return tmp * tmp;
		else return b * tmp * tmp;
	}

	inline int pow(int b, unsigned e)
	{
		if (b >= 0) return static_cast<int>(pow(static_cast<unsigned>(b),e));
		else {
			const int a = static_cast<int>(pow(static_cast<unsigned>(abs(b)),e));
			return (e % 2 == 0) ? a : -a;
		}
	}



}

